/******************************************************************************
**
**  Filename:     g711.h
**
**  System:       RISC
**
**  Platform:     dsPIC33F
**
**  Description:  This file defines the data types and the function protytpes.
**
******************************************************************************/

#ifndef G711_H
#define G711_H

/*-----------------------------------------------------------------------------
           Smart function prototypes for [ag]cc, VaxC, and [tb]cc
-----------------------------------------------------------------------------*/
#if !defined(ARGS)
#if (defined(__STDC__) || defined(VMS) || defined(__DECC)  || defined(MSDOS) || defined(__MSDOS__)) || defined (__CYGWIN__) || defined (_MSC_VER)
#define ARGS(s) s
#else
#define ARGS(s) ()
#endif
#endif

/*-----------------------------------------------------------------------------
                       Function prototypes 
-----------------------------------------------------------------------------*/
void  alaw_compress ARGS ( ( long lseg, short *linbuf, unsigned char *logbuf ) );
void  alaw_expand ARGS ( ( long lseg, unsigned char *logbuf, short *linbuf ) );
void  ulaw_compress ARGS ( ( long lseg, short *linbuf, unsigned char *logbuf ) );
void  ulaw_expand ARGS ( ( long lseg, unsigned char *logbuf, short *linbuf ) );

/*-----------------------------------------------------------------------------
                    PREPROCESSOR CONSTANTS/MACROS
-----------------------------------------------------------------------------*/
#define IS_LIN 1
#define IS_LOG 0

#endif
